<?php

class Ultimate_AI_Theme_Setting_Controller
{
	private $theme_manager;  
	function __construct() {
		$this->theme_manager = new Ultimate_AI_Theme_Setting_Manager();

		add_action("wp_ajax_ultimate_ai_save_theme_settings", [$this, "ultimate_ai_save_theme_settings"]);
		add_action("wp_ajax_ultimate_ai_get_theme_settings", [$this, "ultimate_ai_get_theme_settings"]);
	}

	function ultimate_ai_get_theme_settings(){
		$keys = map_deep( $_POST["keys"], "sanitize_text_field" );
		if( empty($keys) ) return  wp_send_json("Send proper data", 400);
		$settings = $this->theme_manager->ultimate_ai_get_theme_settings( $keys );

		wp_send_json( [ "status" => "success", "data" => ["settings" => $settings] ], 200 );
	}

	function ultimate_ai_save_theme_settings(){
		$this->restrict_req_for_admin();
		$settings = map_deep( $_POST["settings"], "sanitize_text_field" );

		if(empty($settings)) return  wp_send_json("Send proper data", 400);
		$_settings = $this->theme_manager->ultimate_ai_save_theme_settings( $settings );

		wp_send_json( [ "status" => "success", "data" => $_settings], 200 );
	}

	private function restrict_req_for_admin( ) {
		if( !current_user_can("edit_pages") ) {
			wp_send_json("Not authorized", 401);
		}
	}

}

new Ultimate_AI_Theme_Setting_Controller();
